DROP PROCEDURE [hips].[TitleInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 30 October 2012
-- Description:   Inserts a new record into the Title Table
-- =============================================

CREATE PROCEDURE [hips].[TitleInsert] 
(
	@Code VARCHAR(10),
	@Description VARCHAR(10),
	@UserModified VARCHAR(256)
) 
AS
BEGIN
	SET NOCOUNT ON

   DECLARE @intErrorCode INT
          , @TitleId INT
    SELECT   @TitleId = TitleId 
    FROM [hips].Title WHERE Code = @Code      
    SET @intErrorCode = 0
    IF (@TitleId IS NULL)
    BEGIN
		INSERT INTO [hips].[Title]
				( Code,
				  Description,
				  DateCreated,
				  UserCreated,
				  DateModified,
				  UserModified
				)
		VALUES  ( @Code,
				  @Description,
				  GETDATE(), 
				  @UserModified, 
				  GETDATE(), 
				  @UserModified  
				)
		        
		 SELECT @intErrorCode = @@ERROR , @TitleId = SCOPE_IDENTITY()
	END
    IF @intErrorCode = 0
    BEGIN
		SELECT t.TitleId
			,t.Code
			,t.Description
		    ,t.DateCreated
			,t.UserCreated
			,t.DateModified
			,t.UserModified
		FROM hips.Title t
		WHERE @TitleId = t.TitleId
    END

    RETURN(@intErrorCode)

	

END
GO

